function [x_save,func_val,rho,alpha,beta,gamma,delta] = TM_method(L,mu,init,iter,grad,f,X,Y)

rho=1-sqrt(1/(L/mu));
alpha=(1+rho)/L;
beta=rho^2/(2-rho);
gamma=rho^2/((1+rho)*(2-rho));
delta=rho^2/(1-rho^2);

v=init;
d = length(init);
xi = init;
xi_save = xi;
y=init;
x=init;
for i=1:iter+1
  
    y = (1+gamma) * xi - gamma * xi_save;
    x = (1+delta) * xi - delta * xi_save; 
    aux = xi;
    xi = (1+beta) * xi - beta * xi_save - alpha * grad(y,X,Y);
    xi_save = aux;
    func_val(i) = f(x,X,Y);
    x_save(i) = x;
end

end